﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Data;
using System.Data.Linq;
using System.Data.Linq.Mapping;
using System.Reflection;
using System.Text;

namespace VIRP.AHOBPR.DAL.QuestionTool
{
    public partial class BPRDataContext
    {
        [Function(Name = "GetDate", IsComposable = true)]
        public DateTime GetSystemDate()
        {
            MethodInfo mi = MethodBase.GetCurrentMethod() as MethodInfo;
            return (DateTime)this.ExecuteMethodCall(this, mi, new object[] { }).ReturnValue;
        }
    }

    public class AHOBPRDataAccess : BPRDataContext
    {
        #region Constructors
        public AHOBPRDataAccess() : base()
        {
            //InitializeDataContextDebugger();
        }

        public AHOBPRDataAccess(string connection) : base(connection)
        {
            //InitializeDataContextDebugger();
        }

        public AHOBPRDataAccess(System.Data.IDbConnection connection) : base(connection)
        {
            //InitializeDataContextDebugger();
        }

        public AHOBPRDataAccess(string connection, System.Data.Linq.Mapping.MappingSource mappingSource) : base(connection, mappingSource)
        {
            //InitializeDataContextDebugger();
        }

        public AHOBPRDataAccess(System.Data.IDbConnection connection, System.Data.Linq.Mapping.MappingSource mappingSource)
            : base(connection, mappingSource)
        {
            //InitializeDataContextDebugger();
        }

        #endregion        

        //public void InitializeDataContextDebugger()
        //{
        //    if (GlobalSettings.DalLogLing)
        //    {
        //        //this.Log = new Utilities.DebuggerWriter();
        //    }

        //}

        public void SubmitChanges(ConflictMode failureMode, string currentUser)
        {
            ChangeSet changeSet = this.GetChangeSet();
            var updates = (from t in changeSet.Updates select t);
            DateTime now = GetSystemDate();
            //string currentUser = System.Threading.Thread.CurrentPrincipal.Identity.Name;
            foreach (object o in changeSet.Inserts)
            {
                Type type = o.GetType();
                PropertyInfo propCreatedBy = type.GetProperty("CREATEDBY");
                propCreatedBy.SetValue(o, currentUser, null);
                PropertyInfo propCreated = type.GetProperty("CREATED");
                propCreated.SetValue(o, now, null);
                PropertyInfo propUpdatedBy = type.GetProperty("UPDATEDBY");
                propUpdatedBy.SetValue(o, currentUser, null);
                PropertyInfo propUpdated = type.GetProperty("UPDATED");
                propUpdated.SetValue(o, now, null);
            }
            foreach (object o in changeSet.Updates)
            {
                Type type = o.GetType();
                PropertyInfo propUpdatedBy = type.GetProperty("UPDATEDBY");
                propUpdatedBy.SetValue(o, currentUser, null);
                PropertyInfo propUpdated = type.GetProperty("UPDATED");
                propUpdated.SetValue(o, now, null);
            }

            //force connection to open
            if (this.Connection.State != ConnectionState.Open)
            {
                this.Connection.Open();
            }
            //SetContextInfo to username
            //this.sp_SetContextInfo(currentUser);
            base.SubmitChanges(failureMode);
            //Set Context Info back to empty string
            //this.sp_SetContextInfo("");
        }

        public ITable GetTableWithInheritance(DataContext data, Type type)
        {
            try
            {
                return data.GetTable(type);
            }
            catch
            {
                return GetTableWithInheritance(data, type.BaseType); // error was here
            }
        }

    }
}
